﻿using System.Reflection;
using static CamL;

void PrintMenu()
{
    Console.WriteLine("CAM CTL    : [L]=information, [C]=conversiongain, [E]=exposuretime, [T]=TECenable, [t]=TECtarget,\n\t[R]=ROI, [S]=triggerenable, [s]=triggersource, [P]=softwaretrigger\n");
    Console.WriteLine("MISC       : [Q]or[ESC]=end, [?] = menu");
}

char GetKey()
{
    char key = (char)Console.Read();
    while ((key == '\r') || (key == '\n'))
    {
        key = (char)Console.Read();
    }
    return key;
}

CamL h = CamL.Init(2, 115200);
bool done = false;
char c;
char[] model = new char[32], fpgaVer = new char[16], fpgaDate = new char[16], sn = new char[64];
PrintMenu();
while (!done)
{
    Console.WriteLine("USER>");
    c = GetKey();
    Console.ReadLine();

    if (c == '?')
    {
        PrintMenu();
    }

    if ((c == 0x1b) || (c == 'q') || (c == 'Q'))
    {
        done = true;
    }

    //Camera Control
    //Get information about the camera
    if ((c == 'L') || (c == 'l'))
    {
        int pxOffset, pyOffset, pWidth, pHeight;
        string str;
        h.GetModel(out str);
        Console.WriteLine("Model Name \t{0}\n", str);
        h.GetSN(out str);
        Console.WriteLine("SN \t{0}\n", str);
        string ver, date;
        h.GetFpgaVersion(out ver, out date);
        str = new string(fpgaVer, 0, 16);
        Console.WriteLine("Fpga Version \t{0}\n", str);
        str = new string(model, 0, 16);
        Console.WriteLine("Fpga Date \t{0}\n", str);
        Console.WriteLine("Conversion Gain \t{0}\n", h.CG);
        Console.WriteLine("Exposure Time \t{0} [us]\n", h.ExpoTime);
        Console.WriteLine("Max FrameRate \t{0} fps\n", h.MaxFrameRate);
        if (h.TecEnabled)
        {
            Console.WriteLine("TEC Enable \ttrue\n");
            Console.WriteLine("TEC Target \t{0}\n", h.TargetTemperature);
        }
        else
            Console.WriteLine("TEC Enable \tfalse\n");
        Console.WriteLine("Temperature \t{0}\n", h.CurrentTemperature);

        if (h.TriggerEnabled)
        {
            Console.WriteLine("Trigger Enable \ttrue\n");
            Console.WriteLine("Trigger Sourse \t{0}\n", h.TriggerSource);
        }
        else
            Console.WriteLine("Trigger Enable \tfalse\n");
        h.GetRoi(out pxOffset, out pyOffset, out pWidth, out pHeight);
        Console.WriteLine("ROI \t({0},{1},{2},{3})\n", pxOffset, pyOffset, pWidth, pHeight);
    }

    //Set camera conversion gain
    if ((c == 'C') || (c == 'c'))
    {
        Console.WriteLine("Input conversion gain:");
        int cg = int.Parse(Console.ReadLine());
        h.CG = cg;
    }

    //Set camera exposure time
    if ((c == 'E') || (c == 'e'))
    {
        Console.WriteLine("Input exposure time:");
        uint time = uint.Parse(Console.ReadLine());
        h.ExpoTime = time;
    }

    //Set camera TEC enable
    if (c == 'T')
    {
        Console.WriteLine("Input TEC enable:");
        bool enable = bool.Parse(Console.ReadLine());
        h.TecEnabled = enable;
    }
    //Set camera TEC target
    if (c == 't')
    {
        Console.WriteLine("Input TEC target:");
        float target = float.Parse(Console.ReadLine());
        h.TargetTemperature = target;
    }

    //Set camera ROI
    if ((c == 'R') || (c == 'r'))
    {
        Console.WriteLine("Input ROI Xoffset Yoffset width height:");
        string[] parts = Console.ReadLine().Split(' ');
        int pxoffset = int.Parse(parts[0]);
        int pyoffset = int.Parse(parts[1]);
        int pwidth = int.Parse(parts[2]);
        int pheight = int.Parse(parts[3]);
        h. SetRoi(pxoffset, pyoffset, pwidth, pheight);
    }

    //Set camera trigger enable
    if (c == 'S')
    {
        Console.WriteLine("Input trigger enable:");
        bool enable = bool.Parse(Console.ReadLine());
        h.TriggerEnabled = enable;
    }
    //Set camera trigger source
    if (c == 's')
    {
        Console.WriteLine("Input trigger source:");
        int source = int.Parse(Console.ReadLine());
        h.TriggerSource = source;
    }

    //Software Trigger
    if ((c == 'P') || (c == 'p'))
    {
        h.Trigger(true);
        Console.WriteLine("Software Trigger\n");
    }

}