// -----------------------------------------------------------------------------------------
// Sapera++ console Grab Camera Link example
// 
//    
//
// -----------------------------------------------------------------------------------------

// Disable deprecated function warnings with Visual Studio 2005
#if defined(_MSC_VER) && _MSC_VER >= 1400
#pragma warning(disable: 4995)
#endif

#include "stdio.h"
#include "conio.h"
#include "sapclassbasic.h"
#include "ExampleUtils.h"
#include "CameraLinkCmd.h"
#include <math.h>
#include <string>
#include <iostream>
#include <stdio.h>

// Restore deprecated function warnings with Visual Studio 2005
#if defined(_MSC_VER) && _MSC_VER >= 1400
#pragma warning(default: 4995)
#endif

// Static Functions
static void AcqCallback(SapXferCallbackInfo *pInfo);
static void ProCallback(SapProCallbackInfo* pInfo);
int g_picNum;

class SapMyProcessing : public SapProcessing
{
public:
	// Constructor/Destructor
	SapMyProcessing(SapBuffer* pBuffers, SapProCallback pCallback, void* pContext, BOOL hwDecoder = FALSE, SapAcquisition* pAcq = nullptr);
	virtual ~SapMyProcessing();

protected:
	virtual BOOL Run();
};

SapMyProcessing::SapMyProcessing(SapBuffer* pBuffers, SapProCallback pCallback, void* pContext, BOOL hwDecoder, SapAcquisition* pAcq)
	: SapProcessing(pBuffers, pCallback, pContext)
{
}

SapMyProcessing::~SapMyProcessing()
{
	if (m_bInitOK)
		Destroy();
}

// Processing Control
BOOL SapMyProcessing::Run()
{
	return TRUE;
}

typedef struct MyView {
	SapView* View = NULL;
	SapMyProcessing* Pro = NULL;
}*pMyview;

char GetKey() {
	char key = getchar();
	while ((key == '\r') || (key == '\n')) {
		key = getchar();
	}
	return key;
}

void PrintMenu() {
	printf("GRAB CTL   : [0]=stop, [G]=continuous\n");
	printf("CAM CTL    : [L]=information, [C]=conversiongain, [E]=exposuretime, [T]=TECenable, [t]=TECtarget, [R]=ROI, [S]=triggerenable, [s]=triggersource, [P]=softwaretrigger\n");
	printf("MISC       : [Q]or[ESC]=end, [@]=SaveToFile\n");
}

static void AcqCallback(SapXferCallbackInfo* pInfo)
{
	pMyview pView = (pMyview)pInfo->GetContext();

	pView->View->Show();
	pView->Pro->ExecuteNext();
}

// This function is called each time a buffer has been processed by the processing object
//
void ProCallback(SapProCallbackInfo* pInfo)
{
	SapBuffer* pBuffer = (SapBuffer*)pInfo->GetContext();
	const int height = pBuffer->GetHeight(), stride = pBuffer->GetPitch();
	unsigned char* pRaw = nullptr;
	// get the buffer
	pBuffer->GetAddress((void**)&pRaw);
}

void SetRoiPrivate(int &x, int &y, int &width, int &height)
{
	int xPrecision = 8;
	int yPrecision = 1;
	if (x % xPrecision)
		x = x / xPrecision * xPrecision;

	if (width < 16 || width % xPrecision)
	{
		if (width < 16)
			width = 16;
		if (width % xPrecision)
			width = width / xPrecision * xPrecision;
	}

	if (y % yPrecision)
		y = y / yPrecision * yPrecision;

	if (height < 4 || height % yPrecision)
	{
		if (height < 4)
			height = 4;
		if (height % yPrecision)
			height = height / yPrecision * yPrecision;
	}
}

int main(int argc, char* argv[])
{
   int done = FALSE;
   char c;
   char uniqueIndex = 0;
   SapAcquisition	*Acq=NULL;
   SapAcqDevice	*AcqDevice=NULL;
   SapFeature     *Feature=NULL;
   SapBuffer		*Buffers=NULL;
   SapTransfer		*Xfer=NULL;
   MyView	Myview;
   g_picNum = 0;
   UINT32   acqDeviceNumber;
   char*    acqServerName=new char[CORSERVER_MAX_STRLEN];
	char*    configFilename=new char[MAX_PATH];
   BOOL isNotSupported = FALSE,status = FALSE,acquisitionCreated = TRUE,acqDeviceCreated = TRUE;

   printf("Sapera Console Grab Camera Link Example (C++ version)\n");

   //get the SapAquisition (frame grabber)
   if (!GetCorAcquisitionOptionsFromQuestions(acqServerName, &acqDeviceNumber, configFilename))
   {
      printf("\nPress any key to terminate\n");
      CorGetch(); 
      return 0;
   }
   SapLocation loc(acqServerName, acqDeviceNumber);
   if (SapManager::GetResourceCount(acqServerName, SapManager::ResourceAcq) > 0)
   {
	   Acq		= new SapAcquisition(loc, configFilename);
	   Buffers	= new SapBuffer(2, Acq);
	   Myview.View	= new SapView(Buffers, SapHwndAutomatic);
	   Myview.Pro = new SapMyProcessing(Buffers, ProCallback, Buffers);
	   Xfer		= new SapAcqToBuf(Acq, Buffers, AcqCallback, &Myview);
      // Create acquisition object
      if (Acq && !*Acq && !Acq->Create())
         acquisitionCreated = FALSE;   
   }
   
   //create SapAcqDevice
   if (AcqDevice && !*AcqDevice && !AcqDevice->Create())
        acqDeviceCreated = FALSE;

   //if any of the frame grabber or camera failed to initialize, end program
   if (!acquisitionCreated || !acqDeviceCreated)
      goto FreeHandles;
   
   // Create buffer object
   if (Buffers && !*Buffers && !Buffers->Create())
      goto FreeHandles;

   // Create transfer object
   if (Xfer && !*Xfer && !Xfer->Create())
      goto FreeHandles;

   // Create view object
   if (Myview.View && !*(Myview.View) && !Myview.View->Create())
      goto FreeHandles;

   if (Myview.Pro && !*(Myview.Pro) && !Myview.Pro->Create())
	   goto FreeHandles;

   //Initialize the serial port and set the baudrate
   HCamL h = CamL_Init(4, 115200); //portnum is serial com
   char model[32], fpgaVer[16], fpgaDate[16], sn[64];
   PrintMenu();
   while (!done)
   {
	   printf("USER>");
	   c = GetKey();

	   // Stop
	   if (c == '0')
	   {
		   Xfer->Freeze();
		   if (!Xfer->Wait(2000))
		   {
			   Xfer->Abort();
		   }
	   }

	   // Continuous grab.
	   if ((c == 'G') || (c == 'g'))
	   {
		   Xfer->Grab();
	   }

	   if (c == '?')
	   {
		   PrintMenu();
	   }

	   if ((c == 0x1b) || (c == 'q') || (c == 'Q'))
	   {
		   done = TRUE;
	   }

	   if (c == '@')
	   {
		   char filename[256];

		   // Try as TIFF - in case libtiff is present.
		   // Named as COR_<tempname>_<#>.tif
		   sprintf(filename, "img%04d.tif", uniqueIndex++);
		   if (!Buffers->Save(filename, "-format tiff"))
		   {
			   // Try as BMP - Named as COR_<tempname>_<#>.bmp
			   sprintf(filename, "img%04d.bmp", uniqueIndex);
			   Buffers->Save(filename, "-format bmp");
		   }
	   }

	   //Camera Control
	   //Get information about the camera
	   if ((c == 'L') || (c == 'l'))
	   {
		   int pxOffset, pyOffset, pWidth, pHeight;
		   CamL_GetModel(h, model);
		   printf("Model Name \t%s\n", model);
		   CamL_GetSN(h, sn);
		   printf("SN \t%s\n", sn);
		   CamL_GetFpgaVersion(h, fpgaVer, fpgaDate);
		   printf("Fpga Version \t%s\n", fpgaVer);
		   printf("Fpga Date \t%s\n", fpgaDate);
		   printf("Conversion Gain \t%d\n", CamL_GetCG(h));
		   printf("Exposure Time \t%d [us]\n", CamL_GetExpoTime(h));
		   if (CamL_IsTecEnabled(h))
		   {
			   printf("TEC Enable \ttrue\n");
			   printf("TEC Target \t%.1f\n", CamL_GetTargetTemperature(h));
		   }
		   else
			   printf("TEC Enable \tfalse\n");
		   printf("Temperature \t%.1f\n", CamL_GetCurrentTemperature(h));
		   if (CamL_IsTriggerEnabled(h))
		   {
			   printf("Trigger Enable \ttrue\n");
			   printf("Trigger Sourse \t%d\n", CamL_GetTriggerSource(h));
		   }
		   else
			   printf("Trigger Enable \tfalse\n");
		   CamL_GetRoi(h, &pxOffset, &pyOffset, &pWidth, &pHeight);
		   printf("ROI \t(%d,%d,%d,%d)\n", pxOffset, pyOffset, pWidth, pHeight);
	   }

	   //Set camera conversion gain
	   if ((c == 'C') || (c == 'c'))
	   {
		   fflush(stdin);
		   printf("Input conversion gain:");
		   int cg;
		   scanf("%d", &cg);
		   CamL_SetCG(h, cg);
	   }

	   //Set camera exposure time
	   if ((c == 'E') || (c == 'e'))
	   {
		   int time;
		   printf("Input exposure time:");
		   scanf("%d", &time);
		   CamL_SetExpoTime(h, time);
	   }

	   //Set camera TEC enable
	   if (c == 'T')
	   {
		   int enable;
		   printf("Input TEC enable:");
		   scanf("%d", &enable);
		   CamL_EnableTec(h, (bool)enable);
	   }
	   //Set camera TEC target
	   if (c == 't')
	   {
		   float target;
		   printf("Input TEC target:");
		   scanf("%f", &target);
		   CamL_SetTargetTemperature(h, target);
	   }

	   //Set camera ROI
	   if ((c == 'R') || (c == 'r'))
	   {
		   int pxoffset, pyoffset, pwidth, pheight;
		   int maxWidth = 0, maxHeight = 0;
		   printf("Input ROI Xoffset Yoffset width height:");
		   scanf("%d %d %d %d", &pxoffset, &pyoffset, &pwidth, &pheight);
		   SetRoiPrivate(pxoffset, pyoffset, pwidth, pheight);

		   Xfer->Freeze();
		   // Destroy view object
		   if (Myview.View && *(Myview.View) && !Myview.View->Destroy()) done = TRUE;

		   // Destroy transfer object
		   if (Xfer && *Xfer && !Xfer->Destroy()) done = TRUE;

		   // Destroy buffer object
		   if (Buffers && *Buffers && !Buffers->Destroy()) done = TRUE;

		   if (Myview.Pro && !*(Myview.Pro) && !Myview.Pro->Destroy()) done = TRUE;

		   CamL_GetBinSize(h, CamL_GetBin(h), &maxWidth, &maxHeight);
		   if ((pwidth >= maxWidth) && (pheight >= maxHeight))
			   CamL_SetRoi(h, 0, 0, 0, 0); // close ROI
		   else
			   CamL_SetRoi(h, pxoffset, pyoffset, pwidth, pheight);
		   Acq->SetParameter(CORACQ_PRM_CROP_LEFT, 0, FALSE);
		   Acq->SetParameter(CORACQ_PRM_CROP_TOP, 0, FALSE);
		   int taps = 0;
		   Acq->GetParameter(CORACQ_PRM_TAPS, &taps);
		   if (taps > 0)
			   Acq->SetParameter(CORACQ_PRM_HACTIVE, pwidth / taps, FALSE);
		   Acq->SetParameter(CORACQ_PRM_VACTIVE, pheight, FALSE);
		   Acq->SetParameter(CORACQ_PRM_CROP_WIDTH, pwidth, FALSE);
		   Acq->SetParameter(CORACQ_PRM_CROP_HEIGHT, pheight, FALSE);
		   Acq->SetParameter(CORACQ_PRM_SCALE_HORZ, pwidth, FALSE);
		   Acq->SetParameter(CORACQ_PRM_SCALE_VERT, pheight, TRUE);

		   // Create buffer object
		   if (Buffers && !*Buffers && !Buffers->Create())
			   goto FreeHandles;

		   // Create transfer object
		   if (Xfer && !*Xfer && !Xfer->Create())
			   goto FreeHandles;

		   // Create view object
		   if (Myview.View && !*(Myview.View) && !Myview.View->Create())
			   goto FreeHandles;

		   if (Myview.Pro && !*(Myview.Pro) && !Myview.Pro->Create())
			   goto FreeHandles;

		   Xfer->Grab();
	   }

	   //Set camera trigger enable
	   if (c == 'S')
	   {
		   int enable;
		   printf("Input trigger enable:");
		   scanf("%d", &enable);
		   CamL_EnableTrigger(h, (bool)enable);
	   }
	   //Set camera trigger source
	   if (c == 's')
	   {
		   int source;
		   printf("Input trigger source:");
		   scanf("%d", &source);
		   CamL_SetTriggerSource(h, source);
	   }

	   //Software Trigger
	   if ((c == 'P') || (c == 'p'))
	   {
		   int start;
		   printf("Input start:");
		   scanf("%d", &start);
		   CamL_Trigger(h, start);
		   printf("Software Trigger\n");
	   }
   }

   printf("Press any key to stop grab\n");
   CorGetch();

   // Stop grab
   Xfer->Freeze();
   if (!Xfer->Wait(5000))
   {
      printf("Grab could not stop properly.\n");
      Xfer->Abort();
   }
      

//end program
FreeHandles:   
   printf("Press any key to terminate\n");
   CorGetch();

	// Destroy view object
	if (Myview.View && *(Myview.View) && !Myview.View->Destroy()) return FALSE;

	// Destroy transfer object
	if (Xfer && *Xfer && !Xfer->Destroy()) return FALSE;

	// Destroy buffer object
	if (Buffers && *Buffers && !Buffers->Destroy()) return FALSE;

	// Destroy acquisition object
	if (Acq && *Acq && !Acq->Destroy()) return FALSE;

	// Destroy feature object
	if (Feature && *Feature && !Feature->Destroy()) return FALSE;

	// Destroy acquisition object
	if (AcqDevice && *AcqDevice && !AcqDevice->Destroy()) return FALSE;

	if (Myview.Pro && !*(Myview.Pro) && !Myview.Pro->Destroy()) return FALSE;

	if (h) CamL_UnInit(h);
	// Delete all objects
	if (Myview.View)		delete Myview.View;
	if (Xfer)		delete Xfer; 
	if (Buffers)	delete Buffers; 
	if (Acq)		delete Acq; 
	if (Feature)	delete Feature; 
	if (AcqDevice)	delete AcqDevice; 
	if (Myview.Pro)		delete Myview.Pro;

   return 0;
}

extern int g_picNum;